import React from 'react';
import { withThemeByClassName } from '@storybook/addon-themes';
import { HeroUIProvider } from '@heroui/react';
import type { Preview, ReactRenderer } from '@storybook/nextjs';

import '@/styles/global.css';

const decorators: Preview['decorators'] = [
  (Story, { globals: { locale, disableAnimation } }) => {
    const direction =
      // @ts-ignore
      locale && new Intl.Locale(locale)?.textInfo?.direction === 'rtl'
        ? 'rtl'
        : undefined;

    return (
      <HeroUIProvider locale={locale} disableAnimation={disableAnimation}>
        <div className="bg-dark" lang={locale} dir={direction}>
          <Story />
        </div>
      </HeroUIProvider>
    );
  },
  withThemeByClassName<ReactRenderer>({
    themes: {
      light: '',
      dark: 'dark'
    },
    defaultTheme: 'light'
  })
];

const parameters: Preview['parameters'] = {
  actions: { argTypesRegex: '^on[A-Z].*' },
  options: {
    storySort: {
      method: 'alphabetical',
      order: ['Foundations']
    }
  },
  controls: {
    matchers: {
      color: /(background|color)$/i,
      date: /Date$/i
    }
  }
};

const globalTypes: Preview['globalTypes'] = {
  locale: {
    toolbar: {
      icon: 'globe',
      items: ['en', 'ar'].map((locale) => ({
        value: locale,
        title: new Intl.DisplayNames(undefined, { type: 'language' }).of(
          locale
        ),
        right:
          // @ts-ignore
          new Intl.Locale(locale)?.textInfo?.direction === 'rtl'
            ? 'Right to Left'
            : undefined
      }))
    }
  },
  disableAnimation: {
    name: 'Disable Animation',
    description: 'Disable all animations in the stories',
    toolbar: {
      icon: 'photodrag',
      items: [
        { value: true, title: 'True' },
        { value: false, title: 'False' }
      ]
    }
  }
};

const preview: Preview = {
  decorators,
  parameters,
  globalTypes
};

export default preview;
