import type { Meta, StoryObj } from '@storybook/nextjs';
import { Markdown as Component } from './Markdown';

const meta: Meta<typeof Component> = {
  title: 'Shared/Markdown',
  component: Component
};

export default meta;

type Story = StoryObj<typeof meta>;

const sample =
  `# Heading One\n\n` +
  `This is a paragraph with **bold** and *italic* text, as well as a [link](https://example.com).\n\n` +
  `## Heading Two\n\n` +
  `- List item 1\n- List item 2\n- List item 3\n\n` +
  '```ts\n' +
  'type User = { id: string; name: string }\n' +
  '```\n\n' +
  `> Blockquote example.`;

export const Markdown: Story = {
  args: {
    children: sample
  }
};
