import { ResponsiveImage, Source } from './';
import type { ResponsiveImageProps } from './ResponsiveImage';

export default {
  title: 'Shared/ResponsiveImage',
  component: ResponsiveImage,
  parameters: {
    layout: 'fullscreen'
  },
  tags: ['autodocs']
};

export const Image = {
  args: {
    src: 'https://picsum.photos/1920/570?jpg',
    width: 1920,
    height: 570,
    sizes: '100vw'
  }
};

export const ArtDirection = {
  args: {
    src: 'https://picsum.photos/576/570?jpg',
    width: 576,
    height: 540,
    sizes: '100vw'
  },
  render: (args: ResponsiveImageProps) => (
    <ResponsiveImage {...args}>
      <Source
        media="xxl"
        src="https://picsum.photos/1920/540?jpg"
        width={1920}
        height={540}
        sizes="100vw"
      />
      <Source
        media="xl"
        src="https://picsum.photos/1536/540?jpg"
        width={1536}
        height={540}
        sizes="100vw"
      />
      <Source
        media="lg"
        src="https://picsum.photos/1280/540?jpg"
        width={1280}
        height={540}
        sizes="100vw"
      />
      <Source
        media="md"
        src="https://picsum.photos/1024/540?jpg"
        width={1024}
        height={540}
        sizes="100vw"
      />
      <Source
        media="sm"
        src="https://picsum.photos/768/540?jpg"
        width={768}
        height={540}
        sizes="100vw"
      />
      <Source
        media="(min-width: 576px)"
        src="https://picsum.photos/640/540?jpg"
        width={640}
        height={540}
        sizes="100vw"
      />
    </ResponsiveImage>
  )
};
