import React, { forwardRef } from 'react';
import { getImageProps } from 'next/image';

export type Image = {
  url: string;
  width: number;
  height: number;
  alternativeText?: string;
};

export interface ResponsiveImageProps
  extends React.HTMLAttributes<HTMLImageElement> {
  src: string;
  width: number;
  height: number;
  sizes: string;
  alt?: string;
  priority?: boolean;
  quality?: number;
  children?: React.ReactNode;
}

export const ResponsiveImage = forwardRef<
  HTMLImageElement,
  ResponsiveImageProps
>(
  (
    { src, width, height, alt, sizes, quality, priority, children, ...rest },
    ref
  ) => {
    if (src) {
      const { props } = getImageProps({
        src,
        width,
        height,
        sizes,
        quality,
        priority,
        alt: alt || ''
      });

      return (
        <picture>
          {children}
          <img ref={ref} {...props} {...rest} />
        </picture>
      );
    }
  }
);
