import React, { memo } from 'react';
import { getImageProps } from 'next/image';
import breakpoints from './breakpoints';

export type IResponsiveImageSourceProps =
  React.HTMLAttributes<HTMLSourceElement> & {
    src: string;
    width: number;
    height: number;
    media: string;
    sizes: string;
    quality?: number;
  };

export const Source = memo(
  ({
    src,
    width,
    height,
    sizes,
    media,
    quality,
    ...rest
  }: IResponsiveImageSourceProps) => {
    if (src) {
      const query = breakpoints[media] || media;
      const { props } = getImageProps({
        width,
        height,
        src,
        sizes,
        quality,
        alt: ''
      });
      return (
        <source
          media={query}
          src={props.src}
          srcSet={props.srcSet}
          width={props.width}
          height={props.height}
          sizes={props.sizes}
          {...rest}
        />
      );
    }
    return null;
  }
);

Source.displayName = 'ResponsiveImageSource';
