// Conditionally import @next/bundle-analyzer only if ANALYZE is true
const getBundleAnalyzer = async () => {
  if (process.env.ANALYZE === 'true') {
    const withBundleAnalyzer = (await import('@next/bundle-analyzer')).default;
    return withBundleAnalyzer({ enabled: true });
  }
  return (config) => config;
};

/** @type {import('next').NextConfig} */
const nextConfig = {
  images: {
    remotePatterns: [
      {
        protocol: 'https',
        hostname: 's3-ap-southeast-1.amazonaws.com'
      }
    ],
    imageSizes: [64, 128, 256, 576, 768, 992, 1200, 1600, 1920, 2048, 3840]
  },
  async rewrites() {
    return [
      {
        source: '/api/:path*',
        destination: `${process.env.NEXT_PUBLIC_API_URL}/:path*`
      }
    ];
  },
  poweredByHeader: false,
  compress: false
};

const getConfig = async () => {
  const bundleAnalyzer = await getBundleAnalyzer();
  return bundleAnalyzer(nextConfig);
};

export default getConfig();
