import React from 'react';
import Button from './';

export default {
  title: 'Basic/Button',
  component: Button
};

interface TemplateProps {
  variant: 'primary' | 'secondary' | 'link';
}

const Template = ({ variant }: TemplateProps) => {
  return (
    <div>
      <h6 className="mb-2 font-semibold">Size</h6>
      <div className="flex gap-5 mb-4">
        <Button variant={variant} size="sm">
          Small button
        </Button>
        <Button variant={variant}>Medium button</Button>
        <Button variant={variant} size="lg">
          Large button
        </Button>
        <Button variant={variant} href="/" size="sm">
          Small Anchor
        </Button>
        <Button variant={variant} href="/">
          Medium Anchor
        </Button>
        <Button variant={variant} href="/" size="lg">
          Large Anchor
        </Button>
      </div>
      <h6 className="mb-2 font-semibold">Loading</h6>
      <div className="flex gap-5 mb-4">
        <Button variant={variant} size="sm" loading>
          Small button
        </Button>
        <Button variant={variant} loading>
          Medium button
        </Button>
        <Button variant={variant} size="lg" loading>
          Large button
        </Button>
        <Button variant={variant} href="/" size="sm" loading>
          Small Anchor
        </Button>
        <Button variant={variant} href="/" loading>
          Medium Anchor
        </Button>
        <Button variant={variant} href="/" size="lg" loading>
          Large Anchor
        </Button>
      </div>
      <h6 className="mb-2 font-semibold">Disabled</h6>
      <div className="flex gap-5 mb-4">
        <Button variant={variant} size="sm" disabled>
          Small button
        </Button>
        <Button variant={variant} disabled>
          Medium button
        </Button>
        <Button variant={variant} size="lg" disabled>
          Large button
        </Button>
      </div>
      <h6 className="mb-2 font-semibold">Disabled & Loading</h6>
      <div className="flex gap-5 mb-4">
        <Button variant={variant} size="sm" loading disabled>
          Small button
        </Button>
        <Button variant={variant} loading disabled>
          Medium button
        </Button>
        <Button variant={variant} size="lg" loading disabled>
          Large button
        </Button>
      </div>
      <h6 className="mb-2 font-semibold">Multiline</h6>
      <div className="flex gap-5 mb-4">
        <Button variant={variant} size="sm">
          Lorem ipsum dolor sit <br /> amet consectetur adipisicing elit. <br />{' '}
          Quas exercitationem unde voluptate iure dolore laudantium.
        </Button>
        <Button variant={variant}>
          Lorem ipsum dolor sit amet consectetur adipisicing elit. <br /> Quas
          exercitationem unde voluptate iure dolore laudantium.
        </Button>
        <Button variant={variant} size="lg">
          Lorem ipsum dolor sit amet consectetur adipisicing elit. <br /> Quas
          exercitationem unde voluptate iure dolore laudantium.
        </Button>
      </div>
      <br />
      <div className="flex gap-5 mb-4">
        <Button variant={variant} size="sm" loading>
          Lorem ipsum dolor sit <br /> amet consectetur adipisicing elit. <br />{' '}
          Quas exercitationem unde voluptate iure dolore laudantium.
        </Button>
        <Button variant={variant} loading>
          Lorem ipsum dolor sit amet consectetur adipisicing elit. <br /> Quas
          exercitationem unde voluptate iure dolore laudantium.
        </Button>
        <Button variant={variant} size="lg" loading>
          Lorem ipsum dolor sit amet consectetur adipisicing elit. <br /> Quas
          exercitationem unde voluptate iure dolore laudantium.
        </Button>
      </div>
      <h6 className="mb-2 font-semibold">Block</h6>
      <div className="flex flex-col gap-5">
        <Button variant={variant} size="sm" block>
          Small button
        </Button>
        <Button variant={variant} block>
          Medium button
        </Button>
        <Button variant={variant} size="lg" block>
          Large button
        </Button>
        <Button variant={variant} size="sm" block loading>
          Small button
        </Button>
        <Button variant={variant} block loading>
          Medium button
        </Button>
        <Button variant={variant} size="lg" block loading>
          Large button
        </Button>
        <Button variant={variant} size="sm" block loading disabled>
          Small button
        </Button>
        <Button variant={variant} block loading disabled>
          Medium button
        </Button>
        <Button variant={variant} size="lg" block loading disabled>
          Small button
        </Button>
      </div>
    </div>
  );
};

export const Primary = {
  render: () => <Template variant="primary" />
};
export const Secondary = {
  render: () => <Template variant="secondary" />
};
export const Link = {
  render: () => <Template variant="link" />
};
