module.exports = {
  images: {
    remotePatterns: [
      {
        protocol: 'https',
        hostname: 's3-ap-southeast-1.amazonaws.com'
      }
    ],
    imageSizes: [64, 128, 256, 576, 768, 992, 1200, 1600, 1920, 2048, 3840]
  },
  webpack: (config, { isServer }) => {
    if (process.env.ANALYZE && !isServer) {
      const { BundleAnalyzerPlugin } = require('webpack-bundle-analyzer');
      config.plugins.push(
        new BundleAnalyzerPlugin({
          analyzerMode: 'server',
          analyzerPort: 8888,
          openAnalyzer: true
        })
      );
    }
    return config;
  },
  async rewrites() {
    return [
      {
        source: '/api/:path*',
        destination: `${process.env.NEXT_PUBLIC_API_URL}/:path*`
      }
    ];
  },
  poweredByHeader: false,
  compress: false
};
