import type { Config } from 'tailwindcss';

const config: Config = {
  content: [
    './pages/**/*.{js,ts,jsx,tsx,mdx}',
    './components/**/*.{js,ts,jsx,tsx,mdx}',
    './app/**/*.{js,ts,jsx,tsx,mdx}'
  ],
  theme: {
    extend: {
      colors: {
        primary: {
          DEFAULT: 'hsl(340, 76%, 47%)',
          light: 'hsl(340, 76%, 57%)',
          dark: 'hsl(340, 76%, 37%)'
        },
        secondary: {
          DEFAULT: 'hsl(205, 76%, 47%)',
          light: 'hsl(205, 76%, 57%)',
          dark: 'hsl(205, 76%, 37%)'
        },
        light: '#f4f4f4',
        dark: '#222222'
      }
    }
  },
  plugins: []
};
export default config;
