import type { Meta, StoryObj } from '@storybook/nextjs';
import { Button, type ButtonProps } from '@heroui/button';

const meta: Meta<typeof Button> = {
  title: 'Basic/Button',
  component: Button,
  tags: ['autodocs']
};

export default meta;

type Story = StoryObj<typeof meta>;

type TemplateProps = {
  color: ButtonProps['color'];
};

const Template = ({ color }: TemplateProps) => {
  return (
    <div>
      <h6 className="mb-2 font-semibold">Size</h6>
      <div className="flex gap-5 mb-4 flex-wrap items-center">
        <Button color={color} size="sm">
          Small button
        </Button>
        <Button color={color} size="md">
          Medium button
        </Button>
        <Button color={color} size="lg">
          Large button
        </Button>
      </div>
      <h6 className="mb-2 font-semibold">Variants</h6>
      <div className="flex gap-5 mb-4 flex-wrap items-center">
        <Button color={color} variant="solid">
          Solid Button
        </Button>
        <Button color={color} variant="faded">
          Faded Button
        </Button>
        <Button color={color} variant="bordered">
          Bordered Button
        </Button>
        <Button color={color} variant="light">
          Light Button
        </Button>
        <Button color={color} variant="flat">
          Flat Button
        </Button>
        <Button color={color} variant="ghost">
          Ghost Button
        </Button>
        <Button color={color} variant="shadow">
          Shadow Button
        </Button>
      </div>
      <h6 className="mb-2 font-semibold">Loading Variants</h6>
      <div className="flex gap-5 mb-4 flex-wrap items-center">
        <Button color={color} variant="solid">
          Solid Button
        </Button>
        <Button color={color} variant="faded" isLoading>
          Faded Button
        </Button>
        <Button color={color} variant="bordered" isLoading>
          Bordered Button
        </Button>
        <Button color={color} variant="light" isLoading>
          Light Button
        </Button>
        <Button color={color} variant="flat" isLoading>
          Flat Button
        </Button>
        <Button color={color} variant="ghost" isLoading>
          Ghost Button
        </Button>
        <Button color={color} variant="shadow" isLoading>
          Shadow Button
        </Button>
      </div>
      <h6 className="mb-2 font-semibold">Disabled Variants</h6>
      <div className="flex gap-5 mb-4 flex-wrap items-center">
        <Button color={color} variant="solid" isDisabled>
          Solid Button
        </Button>
        <Button color={color} variant="faded" isDisabled>
          Faded Button
        </Button>
        <Button color={color} variant="bordered" isDisabled>
          Bordered Button
        </Button>
        <Button color={color} variant="light" isDisabled>
          Light Button
        </Button>
        <Button color={color} variant="flat" isDisabled>
          Flat Button
        </Button>
        <Button color={color} variant="ghost" isDisabled>
          Ghost Button
        </Button>
        <Button color={color} variant="shadow" isDisabled>
          Shadow Button
        </Button>
      </div>
    </div>
  );
};

export const Default: Story = {
  render: () => <Template color="default" />
};
export const Primary: Story = {
  render: () => <Template color="primary" />
};
export const Secondary: Story = {
  render: () => <Template color="secondary" />
};
