'use client';

import Link from 'next/link';
import { Button, type ButtonProps } from '@heroui/button';
import { type ComponentProps } from 'react';

type LinkButtonProps = Omit<ButtonProps, 'as' | 'href'> & {
  href: string;
} & Pick<ComponentProps<typeof Link>, 'prefetch' | 'replace' | 'scroll'>;

export const LinkButton = ({ href, ...buttonProps }: LinkButtonProps) => {
  return <Button as={Link} href={href} {...buttonProps} />;
};
