import type { Meta, StoryObj } from '@storybook/nextjs';
import { ResponsiveVideo as ResponsiveVideoComponent } from './ResponsiveVideo';

const meta: Meta<typeof ResponsiveVideoComponent> = {
  title: 'Shared/ResponsiveVideo',
  component: ResponsiveVideoComponent,
  parameters: {
    layout: 'centered'
  },
  tags: ['autodocs']
};

export default meta;

type Story = StoryObj<typeof meta>;

const fallback = (
  <h3 className="font-bold text-lg text-light bg-primary px-4 py-2">
    Auto play failed. I am a fallback element
  </h3>
);

const noSrcFallback = (
  <div className="font-bold text-lg text-light bg-primary px-4 py-2">
    No video source available. I am a fallback element
  </div>
);

export const ResponsiveVideo: Story = {
  args: {
    src: 'https://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerFun.mp4',
    srcSet: [
      {
        src: 'https://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerBlazes.mp4',
        media: 'md'
      },
      {
        src: 'https://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerEscapes.mp4',
        media: '(min-width: 900px)'
      }
    ],
    fallback,
    autoPlay: true,
    controls: true,
    muted: true
  }
};

export const AutoPlayFailed: Story = {
  args: {
    src: 'broken.mp4',
    autoPlay: true,
    fallback
  }
};

export const NoSrcWithFallback: Story = {
  args: {
    fallback: noSrcFallback
  }
};
