// Conditionally import @next/bundle-analyzer only if ANALYZE is true
const getBundleAnalyzer = async () => {
  if (process.env.ANALYZE === 'true') {
    const withBundleAnalyzer = (await import('@next/bundle-analyzer')).default;
    return withBundleAnalyzer({ enabled: true });
  }
  return (config) => config;
};

/** Assets URL is required at build time */
const assetsUrl = new URL(process.env.APP_ASSETS_URL);

/** @type {import('next').NextConfig} */
const nextConfig = {
  images: {
    remotePatterns: [
      {
        protocol: assetsUrl.protocol.replace(':', ''),
        hostname: assetsUrl.hostname
      }
    ],
    imageSizes: [64, 128, 256, 576, 768, 992, 1200, 1600, 1920, 2048, 3840]
  },
  async rewrites() {
    return [
      {
        source: '/images/static/:path*',
        destination: `/_next/image?url=${encodeURIComponent('/_next/static/media' + '/:path*')}`
      },
      {
        source: '/images/:path*',
        destination: `/_next/image?url=${encodeURIComponent(assetsUrl.toString() + '/:path*')}`
      },
      {
        source: '/assets/:path*',
        destination: `${assetsUrl.toString() + '/:path*'}`
      }
    ];
  },
  poweredByHeader: false,
  compress: false
};

const getConfig = async () => {
  const bundleAnalyzer = await getBundleAnalyzer();
  return bundleAnalyzer(nextConfig);
};

export default getConfig();
