# NEXTJS STARTER TEMPLATE

## Tools Configured

- Next.js
- React Storybook
- Typescript
- Tailwind CSS
- Hero UI
- pnpm
- Commitizen
- Editorconfig
- Eslint
- Prettier
- Husky (to lint commit messages)

## Important Notes

- Enable nodejs corepack `corepack enable`
- Install pnpm using `corepack prepare pnpm@latest --activate`
- Install dependencies using `pnpm install`
- Install commitizen globally `npm install -g commitizen`
- Then, use `git cz` or `cz` to commit changes
- Commit messages must follow [angular conventional commit
  standards](https://github.com/conventional-changelog/commitlint)
- Install prettier extension in editor. Enable "Format on save" option.
- Install editorconfig extension in editor.
- All files will be formatted using prettier before commit

### Development Server

```bash
pnpm dev
```

### Build Task

```bash
pnpm build
```

### Production Server

```bash
pnpm start
```

### Run Storybook

```bash
pnpm storybook
```

### Build Static Storybook

```bash
pnpm build-storybook
```
