import MarkdownToJsx, { type MarkdownToJSX } from 'markdown-to-jsx';
import { cn } from '@heroui/theme';

export type MarkdownProps = {
  children: string;
  options?: MarkdownToJSX.Options;
  className?: string;
};

export const Markdown = ({ children, options, className }: MarkdownProps) => {
  return (
    <MarkdownToJsx
      options={options}
      className={cn(
        'text-start prose prose-headings:font-semibold prose-headings:mb-4',
        className
      )}>
      {children}
    </MarkdownToJsx>
  );
};
