# Nextjs Starter Template

## Tools Configured

- Next.js
- React Storybook
- Typescript
- Tailwind CSS
- yarn 4
- Commitizen
- Editorconfig
- Eslint
- Prettier
- Husky (to lint commit messages)

## Important Notes

- Install Yarn using `corepack enable`
- Set yarn version to latest using `yarn set version stable`
- Install dependencies using `yarn install`
- Install commitizen globally `npm install -g commitizen`
- Then, use `git cz` or `cz` to commit changes
- Commit messages must follow [angular conventional commit
  standards](https://github.com/conventional-changelog/commitlint)
- Install prettier extension in editor. Enable "Format on save" option.
- Install editorconfig extension in editor.
- All files will be formatted using prettier before commit

### Development Server

```bash
yarn dev
```

### Build Task

```bash
yarn build
```

### Production Server

```bash
yarn start
```

### Run Storybook

```bash
yarn storybook
```

### Build Static Storybook

```bash
yarn build-storybook
```
