import cn from 'classnames';
import Link from 'next/link';

interface ButtonProps extends React.HTMLAttributes<HTMLElement> {
  variant?: 'default' | 'primary' | 'secondary' | 'link';
  size?: 'sm' | 'md' | 'lg';
  block?: boolean;
  loading?: boolean;
  disabled?: boolean;
  href?: string;
  children: React.ReactNode;
}

export default function Button({
  variant = 'primary',
  size = 'md',
  block = false,
  loading = false,
  disabled = false,
  href,
  children,
  ...rest
}: ButtonProps) {
  const classNames = cn('inline-flex items-center transition-colors', {
    'px-4 py-2': variant !== 'link',
    'text-light': variant !== 'link',
    'font-semibold': variant !== 'link',
    /** backgrounds */
    'bg-gray-200': disabled && variant !== 'link',
    'bg-primary hover:bg-primary-light': !disabled && variant === 'primary',
    'bg-secondary hover:bg-secondary-light':
      !disabled && variant === 'secondary',
    /** text */
    'text-gray-400': disabled,
    'text-sm': size === 'sm',
    'text-base': size === 'md',
    'text-lg': size === 'lg',
    /** block */
    'w-full justify-center': block
  });

  return typeof href === 'string' ? (
    <Link href={href} className={classNames} {...rest}>
      {children}
      {loading && <Loader />}
    </Link>
  ) : (
    <button disabled={disabled} className={classNames} {...rest}>
      {children}
      {loading && <Loader />}
    </button>
  );
}

function Loader() {
  return (
    <span className="rounded-full h-5 w-5 border-2 border-b-transparent border-current animate-spin ms-1" />
  );
}
