const path = require('path');

module.exports = {
  typescript: { reactDocgen: false },
  core: {
    builder: 'webpack5'
  },
  stories: ['../stories/**/*.stories.@(ts|tsx|js|jsx|mdx)'],
  addons: [
    '@storybook/addon-links',
    '@storybook/addon-essentials',
    {
      name: '@storybook/preset-scss',
      options: {
        cssLoaderOptions: {
          modules: {
            localIdentName: '[local]--[hash:base64:5]'
          }
        }
      }
    }
  ],
  webpackFinal: (config) => {
    config.resolve = {
      ...config.resolve,
      alias: {
        ...config.resolve.alias,
        'next/link': path.resolve(__dirname, '../stories/__mocks__/link.js'),
        '@components': path.resolve(__dirname, '../components'),
        '@containers': path.resolve(__dirname, '../containers'),
        '@lib': path.resolve(__dirname, '../lib'),
        '@styles': path.resolve(__dirname, '../styles')
      }
    };

    return config;
  }
};
