import PropTypes from 'prop-types';
import cn from 'classnames';
import Link from 'next/link';
import styles from './styles.module.scss';

export default function Button({
  type = 'primary',
  size = 'medium',
  block = false,
  loading = false,
  disabled = false,
  href = null,
  children,
  ...rest
}) {
  const classNames = cn({
    [styles.button]: true,
    /** assign styles[type], so that, undefined
     * doesn't show up in class names
     */
    [styles[type]]: styles[type],
    [styles[size]]: styles[size],
    [styles.block]: block,
    [styles.loading]: loading,
    [styles.disabled]: disabled
  });

  return href !== null ? (
    <Link href={href}>
      <a className={classNames} {...rest}>
        {children}
      </a>
    </Link>
  ) : (
    <button {...rest} className={classNames}>
      {children}
    </button>
  );
}

Button.propTypes = {
  /** Type of the button, link renders <a> tag */
  type: PropTypes.oneOf([
    'default',
    'primary',
    'secondary',
    'tertiary',
    'link'
  ]),
  /** The size of the button */
  size: PropTypes.oneOf(['small', 'medium', 'large']),
  /** displays the button in full width */
  block: PropTypes.bool,
  /** Shows loading state of button. It disables interaction */
  loading: PropTypes.bool,
  /** Disables the button */
  disabled: PropTypes.bool,
  /** href renders anchor tag with href attribute */
  href: PropTypes.string
};
