module.exports = {
  webpack: (config, { isServer }) => {
    if (process.env.ANALYZE && !isServer) {
      const { BundleAnalyzerPlugin } = require('webpack-bundle-analyzer');
      config.plugins.push(
        new BundleAnalyzerPlugin({
          analyzerMode: 'server',
          analyzerPort: 8888,
          openAnalyzer: true
        })
      );
    }
    config.module.rules.push({
      test: /\.(png|svg|jpg|jpeg|gif|mp3|mp4)$/i,
      // Next.js already handles url() in css/sass/scss files
      issuer: /\.\w+(?<!(s?c|sa)ss)$/i,
      type: 'asset/resource',
      generator: {
        filename: 'static/media/[name]-[hash:8][ext]'
      }
    });
    return config;
  },
  images: {
    disableStaticImages: true
  },
  async rewrites() {
    return [
      {
        source: '/',
        destination: '/home'
      },
      {
        source: '/api/:path*',
        destination: `${process.env.NEXT_PUBLIC_API_URL}/:path*`
      }
    ];
  },
  env: {
    homeUrl: '/home'
  },
  poweredByHeader: false,
  compress: false
};
