# Next.js starter template

## Tools Configured

- Next.js
- React Storybook
- webpack 5
- Commitizen
- Editorconfig
- Prettier
- Husky (to lint commit messages)

## Important Notes

- Install commitizen globally `yarn global add commitizen`
- Then, use `git cz` to commit changes
- Commit messages must follow [angular conventional commit
  standards](https://github.com/conventional-changelog/commitlint)
- Install prettier extension in editor. Enable "Format on save" option.
- Install editorconfig extension in editor.
- All files will be formatted using prettier before commit

### Development Server

```bash
yarn dev
```

### Build Task

```bash
yarn build
```

### Production Server

```bash
yarn start
```

### Run Storybook

```bash
yarn storybook
```

### Build Static Storybook

```bash
yarn build-storybook
```
