module.exports = {
  experimental: { appDir: true },
  images: {
    domains: [''],
    deviceSizes: [128, 384],
    imageSizes: [640, 828, 1200, 1600, 1920, 2048]
  },
  webpack: (config, { isServer }) => {
    if (process.env.ANALYZE && !isServer) {
      const { BundleAnalyzerPlugin } = require('webpack-bundle-analyzer');
      config.plugins.push(
        new BundleAnalyzerPlugin({
          analyzerMode: 'server',
          analyzerPort: 8888,
          openAnalyzer: true
        })
      );
    }
    return config;
  },
  async rewrites() {
    return [
      {
        source: '/',
        destination: '/home'
      },
      {
        source: '/api/:path*',
        destination: `${process.env.NEXT_PUBLIC_API_URL}/:path*`
      }
    ];
  },
  env: {
    homeUrl: '/home'
  },
  poweredByHeader: false,
  compress: false
};
