import React from 'react';
import { Space, DarkBg } from '../_helpers';
import Button from '@components/button';

export default {
  title: 'Basic/Button',
  component: Button
};

const Template = ({ type }) => {
  return (
    <div>
      <h6>Size</h6>
      <Space>
        <Button type={type} size="small">
          Small button
        </Button>
        <Button type={type}>Medium button</Button>
        <Button type={type} size="large">
          Large button
        </Button>
      </Space>
      <Space>
        <Button type={type} href="/" size="small">
          Small Anchor
        </Button>
        <Button type={type} href="/">
          Medium Anchor
        </Button>
        <Button type={type} href="/" size="large">
          Large Anchor
        </Button>
      </Space>
      <h6>Loading</h6>
      <Space>
        <Button type={type} size="small" loading>
          Small button
        </Button>
        <Button type={type} loading>
          Medium button
        </Button>
        <Button type={type} size="large" loading>
          Large button
        </Button>
      </Space>
      <Space>
        <Button type={type} href="/" size="small" loading>
          Small Anchor
        </Button>
        <Button type={type} href="/" loading>
          Medium Anchor
        </Button>
        <Button type={type} href="/" size="large" loading>
          Large Anchor
        </Button>
      </Space>
      <h6>Disabled</h6>
      <Space>
        <Button type={type} size="small" disabled>
          Small button
        </Button>
        <Button type={type} disabled>
          Medium button
        </Button>
        <Button type={type} size="large" disabled>
          Large button
        </Button>
      </Space>
      <h6>Disabled & Loading</h6>
      <Space>
        <Button type={type} size="small" loading disabled>
          Small button
        </Button>
        <Button type={type} loading disabled>
          Medium button
        </Button>
        <Button type={type} size="large" loading disabled>
          Large button
        </Button>
      </Space>
      <h6>Multiline</h6>
      <Space>
        <Button type={type} size="small">
          Lorem ipsum dolor sit <br /> amet consectetur adipisicing elit. <br />{' '}
          Quas exercitationem unde voluptate iure dolore laudantium.
        </Button>
        <Button type={type}>
          Lorem ipsum dolor sit amet consectetur adipisicing elit. <br /> Quas
          exercitationem unde voluptate iure dolore laudantium.
        </Button>
        <Button type={type} size="large">
          Lorem ipsum dolor sit amet consectetur adipisicing elit. <br /> Quas
          exercitationem unde voluptate iure dolore laudantium.
        </Button>
      </Space>
      <br />
      <Space>
        <Button type={type} size="small" loading>
          Lorem ipsum dolor sit <br /> amet consectetur adipisicing elit. <br />{' '}
          Quas exercitationem unde voluptate iure dolore laudantium.
        </Button>
        <Button type={type} loading>
          Lorem ipsum dolor sit amet consectetur adipisicing elit. <br /> Quas
          exercitationem unde voluptate iure dolore laudantium.
        </Button>
        <Button type={type} size="large" loading>
          Lorem ipsum dolor sit amet consectetur adipisicing elit. <br /> Quas
          exercitationem unde voluptate iure dolore laudantium.
        </Button>
      </Space>
      <h6>Block</h6>
      <Button type={type} size="small" block>
        Small button
      </Button>
      <br />
      <Button type={type} block>
        Medium button
      </Button>
      <br />
      <Button type={type} size="large" block>
        Large button
      </Button>
      <br />
      <Button type={type} size="small" block loading>
        Small button
      </Button>
      <br />
      <Button type={type} block loading>
        Medium button
      </Button>
      <br />
      <Button type={type} size="large" block loading>
        Large button
      </Button>
      <br />
      <Button type={type} size="small" block loading disabled>
        Small button
      </Button>
      <br />
      <Button type={type} block loading disabled>
        Medium button
      </Button>
      <br />
      <Button type={type} size="large" block loading disabled>
        Small button
      </Button>
    </div>
  );
};

export const Primary = () => <Template type="primary" />;
export const Secondary = () => <Template type="secondary" />;
export const Link = () => <Template type="link" />;
