import { useEffect } from 'react';

export const NoPadding = (props) => {
  useEffect(() => {
    document.body.style.padding = '0';
    return () => (document.body.style.padding = '');
  });

  return <div {...props} />;
};

export const DarkBg = (props) => {
  useEffect(() => {
    document.body.style.background = '#333';
    document.body.style.color = '#ccc';
    return () => {
      document.body.style.background = '';
      document.body.style.color = '';
    };
  });

  return <>{props.children}</>;
};

export const Space = (props) =>
  props.children.map((element) => (
    <div style={{ padding: '0.5em', display: 'inline-block' }}>{element}</div>
  ));
