export interface Entry {
  id?: string
  text: string
  imageUrl?: string
  weight?: number
  color?: string
  order?: number
}

export interface WheelSettings {
  duringSpin: {
    sound: string
    volume: number
    displayDuplicates: boolean
    spinSlowly: boolean
    showTitle: boolean
    spinTime: number
    maxVisibleNames: number
  }
  afterSpin: {
    sound: string
    volume: number
    animateWinningEntry: boolean
    launchConfetti: boolean
    autoRemoveWinner: number | null
    displayPopup: boolean
    popupMessage: string
    displayRemoveButton: boolean
    playClickSoundOnRemove: boolean
  }
  appearance: {
    colorScheme: 'one-color' | 'background-image'
    theme: string
    colors: string[]
    centerImage?: string
    centerImageSize: 'S' | 'M' | 'L'
    pageBackgroundColor?: string
    displayGradient: boolean
    contours: boolean
    wheelShadow: boolean
    pointerChangesColor: boolean
  }
}

export interface Result {
  id?: string
  entryId: string
  entryText: string
  spunAt?: Date
}

