# Spin The Wheel - Random Name Picker

A full-stack wheel spinner application with support for up to 10,000 entries, built with React, Node.js, and PostgreSQL.

## Features

- **Wheel Spinning**: Physics-based animation with cryptographically secure random selection
- **Large Dataset Support**: Handle up to 10,000 entries (10x the original wheelofnames.com limit)
- **Customization**: Extensive settings for spin behavior, appearance, and post-spin actions
- **Results Management**: Track spin history with results tab
- **Real-time Database Sync**: Automatic saving of wheels and results
- **File Upload**: Import entries from CSV/TXT files
- **Dynamic Font Sizing**: Text automatically adjusts to fit full names within segments

## Technology Stack

- **Frontend**: React 18 + TypeScript + Vite
- **Backend**: Node.js + Express + TypeScript
- **Database**: PostgreSQL + Prisma ORM
- **Randomness**: crypto.getRandomValues() / crypto.randomBytes()

## Project Structure

```
wheeler/
├── frontend/          # React frontend application
├── backend/           # Express backend API
└── README.md
```

## Quick Start

### Prerequisites

- Node.js 18+ and npm
- PostgreSQL database

### Option 1: Combined Setup (Recommended)

1. **Install all dependencies, generate Prisma client, and run migrations:**
```bash
npm run setup
```

2. **Configure backend environment:**
```bash
cd backend
cp .env.example .env
```

3. **Update `backend/.env` with your PostgreSQL connection:**
```env
DATABASE_URL="postgresql://user:password@localhost:5432/wheeler?schema=public"
PORT=5000
NODE_ENV=development
ALLOWED_ORIGINS=http://localhost:3000,http://localhost:5173
```

4. **Start both frontend and backend:**
```bash
npm run dev
```

The frontend will run on `http://localhost:3000` and backend on `http://localhost:5000`

### Option 2: Manual Setup

#### Backend Setup

1. Navigate to backend directory:
```bash
cd backend
```

2. Install dependencies:
```bash
npm install
```

3. Create `.env` file:
```bash
cp .env.example .env
```

4. Update `.env` with your PostgreSQL connection string:
```env
DATABASE_URL="postgresql://user:password@localhost:5432/wheeler?schema=public"
PORT=5000
NODE_ENV=development
ALLOWED_ORIGINS=http://localhost:3000,http://localhost:5173
```

5. Generate Prisma client:
```bash
npm run db:generate
```

6. Run database migrations:
```bash
npm run db:migrate
```

7. Start the backend server:
```bash
npm run dev
```

#### Frontend Setup

1. Navigate to frontend directory:
```bash
cd frontend
```

2. Install dependencies:
```bash
npm install
```

3. Start the development server:
```bash
npm run dev
```

## Available Scripts

### Root Level (Combined)

- `npm run setup` - Install all dependencies, generate Prisma client, and run migrations
- `npm run install:all` - Install dependencies for both frontend and backend
- `npm run dev` - Start both frontend and backend in development mode
- `npm run build` - Build both frontend and backend for production
- `npm run start` - Start both frontend and backend in production mode
- `npm run db:generate` - Generate Prisma client
- `npm run db:migrate` - Run database migrations
- `npm run db:studio` - Open Prisma Studio

### Backend Scripts

- `npm run dev` - Start development server with hot reload
- `npm run build` - Build for production
- `npm run start` - Start production server
- `npm run db:generate` - Generate Prisma client
- `npm run db:migrate` - Run database migrations
- `npm run db:studio` - Open Prisma Studio

### Frontend Scripts

- `npm run dev` - Start development server
- `npm run build` - Build for production
- `npm run preview` - Preview production build

## Usage

1. **Add Entries**: 
   - Type entries in the text area, one per line
   - Or click "Upload CSV" to import from a file
   - Supports up to 10,000 entries

2. **Customize**: Click "Customize" to adjust:
   - Spin settings (sound, volume, spin time, max visible names)
   - Appearance (colors, themes, shadows, contours)
   - Post-spin behavior (confetti, popup, auto-remove winner)

3. **Spin**: Click the wheel or press Ctrl+Enter to spin

4. **View Results**: Switch to the Results tab to see spin history

5. **Real-time Sync**: All changes are automatically saved to the database

## Large Dataset Support

For wheels with more than 1,000 entries:
- Selection happens on the backend for optimal performance
- Frontend displays a configurable subset (up to 10,000 visible entries)
- All entries have equal chance of winning regardless of visibility

## Environment Variables

### Backend (.env)

```env
DATABASE_URL="postgresql://user:password@localhost:5432/wheeler?schema=public"
PORT=5000
NODE_ENV=development
ALLOWED_ORIGINS=http://localhost:3000,http://localhost:5173,https://yourdomain.com
```

- `DATABASE_URL`: PostgreSQL connection string
- `PORT`: Backend server port (default: 5000)
- `NODE_ENV`: Environment (development/production)
- `ALLOWED_ORIGINS`: Comma-separated list of allowed frontend URLs for CORS

## API Endpoints

### Wheels
- `POST /api/wheels` - Create new wheel
- `GET /api/wheels/:id` - Get wheel
- `GET /api/wheels/recent` - Get most recent wheel
- `PUT /api/wheels/:id` - Update wheel
- `DELETE /api/wheels/:id` - Delete wheel
- `GET /api/wheels/gallery` - Get public wheels
- `POST /api/wheels/:id/share` - Generate share link

### Entries
- `GET /api/entries/:wheelId` - Get entries
- `POST /api/entries/:wheelId` - Add entries
- `DELETE /api/entries/:wheelId/:entryId` - Remove entry
- `DELETE /api/entries/:wheelId/clear` - Clear all entries

### Spin
- `POST /api/spin` - Perform spin (returns winner)

### Results
- `GET /api/results/:wheelId` - Get results
- `POST /api/results/:wheelId` - Add result
- `DELETE /api/results/:wheelId/:resultId` - Remove result
- `DELETE /api/results/:wheelId` - Clear all results

## Development

### Running in Development

From the root directory:
```bash
npm run dev
```

This starts both frontend (port 3000) and backend (port 5000) concurrently.

### Database Management

- **Prisma Studio**: `npm run db:studio` - Visual database browser
- **Migrations**: `npm run db:migrate` - Run pending migrations
- **Generate Client**: `npm run db:generate` - Regenerate Prisma client after schema changes

## Production Deployment

1. Build both frontend and backend:
```bash
npm run build
```

2. Set production environment variables in `backend/.env`

3. Start production servers:
```bash
npm run start
```

## License

MIT
