import axios from 'axios'

const api = axios.create({
  baseURL: '/api', // Uses Vite proxy to backend
  headers: {
    'Content-Type': 'application/json',
  },
})

// Wheel endpoints
export const wheelApi = {
  create: (data: any) => api.post('/wheels', data),
  get: (id: string) => api.get(`/wheels/${id}`),
  update: (id: string, data: any) => api.put(`/wheels/${id}`, data),
  delete: (id: string) => api.delete(`/wheels/${id}`),
  getGallery: () => api.get('/wheels/gallery'),
  getRecent: () => api.get('/wheels/recent'),
  share: (id: string) => api.post(`/wheels/${id}/share`),
}

// Entry endpoints
export const entryApi = {
  validate: (entries: string[]) => api.post('/entries/validate', { entries }),
  process: (entries: any[], maxVisible: number) =>
    api.post('/entries/process', { entries, maxVisible }),
  get: (wheelId: string) => api.get(`/entries/${wheelId}`),
  add: (wheelId: string, entries: any[]) =>
    api.post(`/entries/${wheelId}`, { entries }),
  remove: (wheelId: string, entryId: string) =>
    api.delete(`/entries/${wheelId}/${entryId}`),
  clearAll: (wheelId: string) => api.delete(`/entries/${wheelId}/clear`),
}

// Spin endpoints
export const spinApi = {
  perform: (payload: { wheelId?: string; entries?: any[] }) => api.post('/spin', payload),
}

// Result endpoints
export const resultApi = {
  get: (wheelId: string) => api.get(`/results/${wheelId}`),
  add: (wheelId: string, entryId: string) =>
    api.post(`/results/${wheelId}`, { entryId }),
  remove: (wheelId: string, resultId: string) =>
    api.delete(`/results/${wheelId}/${resultId}`),
  clear: (wheelId: string) => api.delete(`/results/${wheelId}`),
}

export default api

