import { Request, Response } from 'express'
import prisma from '../services/prisma.js'

export const getResults = async (req: Request, res: Response) => {
  try {
    const { wheelId } = req.params

    const results = await prisma.result.findMany({
      where: { wheelId },
      include: {
        entry: true,
      },
      orderBy: { spunAt: 'desc' },
    })

    res.json(results)
  } catch (error: any) {
    res.status(500).json({ error: error.message })
  }
}

export const addResult = async (req: Request, res: Response) => {
  try {
    const { wheelId } = req.params
    const { entryId } = req.body

    if (!entryId) {
      return res.status(400).json({ error: 'Entry ID is required' })
    }

    const result = await prisma.result.create({
      data: {
        wheelId,
        entryId,
      },
      include: {
        entry: true,
      },
    })

    res.json(result)
  } catch (error: any) {
    res.status(500).json({ error: error.message })
  }
}

export const removeResult = async (req: Request, res: Response) => {
  try {
    const { wheelId, resultId } = req.params

    await prisma.result.delete({
      where: { id: resultId },
    })

    res.json({ message: 'Result removed successfully' })
  } catch (error: any) {
    res.status(500).json({ error: error.message })
  }
}

export const clearResults = async (req: Request, res: Response) => {
  try {
    const { wheelId } = req.params

    await prisma.result.deleteMany({
      where: { wheelId },
    })

    res.json({ message: 'Results cleared successfully' })
  } catch (error: any) {
    res.status(500).json({ error: error.message })
  }
}

