import express from 'express'
import {
  validateEntries,
  processEntries,
  getEntries,
  addEntries,
  removeEntry,
  clearAllEntries,
} from '../controllers/entryController.js'

const router = express.Router()

router.post('/validate', validateEntries)
router.post('/process', processEntries)
router.get('/:wheelId', getEntries)
router.post('/:wheelId', addEntries)
router.delete('/:wheelId/clear', clearAllEntries)
router.delete('/:wheelId/:entryId', removeEntry)

export default router

