import express from 'express'
import cors from 'cors'
import dotenv from 'dotenv'
import wheelRoutes from './routes/wheelRoutes.js'
import entryRoutes from './routes/entryRoutes.js'
import spinRoutes from './routes/spinRoutes.js'
import resultRoutes from './routes/resultRoutes.js'

dotenv.config()

const app = express()
const PORT = process.env.PORT || 5000

// CORS configuration - allow all origins
const corsOptions = {
  origin: true, // Allow all origins
  credentials: true,
  optionsSuccessStatus: 200
}

// Middleware
app.use(cors(corsOptions))
app.use(express.json())

// Routes
app.use('/api/wheels', wheelRoutes)
app.use('/api/entries', entryRoutes)
app.use('/api/spin', spinRoutes)
app.use('/api/results', resultRoutes)

// Health check
app.get('/api/health', (req, res) => {
  res.json({ status: 'ok', message: 'Spin The Wheel API is running' })
})

app.listen(PORT, () => {
  // Server started successfully
})

