import express from 'express'
import {
  getResults,
  addResult,
  removeResult,
  clearResults,
} from '../controllers/resultController.js'

const router = express.Router()

router.get('/:wheelId', getResults)
router.post('/:wheelId', addResult)
router.delete('/:wheelId/:resultId', removeResult)
router.delete('/:wheelId', clearResults)

export default router

