import express from 'express'
import {
  createWheel,
  getWheel,
  updateWheel,
  deleteWheel,
  getGalleryWheels,
  shareWheel,
  getRecentWheel,
} from '../controllers/wheelController.js'

const router = express.Router()

router.post('/', createWheel)
router.get('/gallery', getGalleryWheels)
router.get('/recent', getRecentWheel)
router.get('/:id', getWheel)
router.put('/:id', updateWheel)
router.delete('/:id', deleteWheel)
router.post('/:id/share', shareWheel)

export default router

